-- CUSTOM ERRORS --
use Filmler
go
exec sp_addmessage @msgnum = 50001, @severity = 16, @msgtext = 'Bu bir hata mesajdr!', @with_log = 'true'
-- @msgnum: 0 - 49999 (Sistem mesajlar)
--		    50000 - ... (raiserror kaynakl bizim kendi rettiimiz hatalar)
-- @severity: 0 - 16 (Kullanc veri giriinden kaynakl hatalar, bu hatalar kullanc dzeltebilir)
--			  17 (Disk dolu hatas)
--			  18 (Yazlmdan kaynakl bir hata)
--			  19 (constraint hatas)
--			  20 - 25 (ok kritik hatalar)
-- @msgtext: Mesaj string'i
-- @with_log: true (Windows tarafndan log tutulup tutulmayacan belirtir)
-----------------------------------------------------------------------------------------------------------
-- Hatay kullanma:
go
create proc sp_hatayidene @id int
as
declare @count int
select @count = COUNT(*) from Film where id = @id
if @count = 0
begin	
	raiserror (50001, 16, 1)
end
else
begin
	select * from Film where id = @id
end
-----------------------------------------------------------------------------------------------------------
go
exec sp_hatayidene 1
-----------------------------------------------------------------------------------------------------------
go
exec sp_hatayidene 0
-----------------------------------------------------------------------------------------------------------
go
drop proc sp_hatayidene
go
exec sp_dropmessage 50001 -- oluturulan hata mesajn siler